package cn.lsmya.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;

public class ItemEditView extends LinearLayout {
    private ImageView leftImageView;
    private ImageView rightImageView;
    private TextView titleTextView;
    private EditText inputTextView;
    private View dividerView;

    public ItemEditView(Context context) {
        super(context);
        init(context, null);
    }

    public ItemEditView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(context, attrs);
    }

    public ItemEditView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        View view = inflate(context, R.layout.helper_item_edit, this);
        leftImageView = view.findViewById(R.id.helperItemEdit_leftImageView);
        rightImageView = view.findViewById(R.id.helperItemEdit_rightImageView);
        titleTextView = view.findViewById(R.id.helperItemEdit_titleTextView);
        inputTextView = view.findViewById(R.id.helperItemEdit_inputView);
        dividerView = view.findViewById(R.id.helperItemEdit_dividerLine);
        if (attrs == null) {
            return;
        }
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ItemEditView);
        for (int i = 0; i < typedArray.getIndexCount(); i++) {
            int attr = typedArray.getIndex(i);
            if (attr == R.styleable.ItemEditView_leftIcon) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    leftImageView.setVisibility(VISIBLE);
                    leftImageView.setImageResource(resId);
                } else {
                    leftImageView.setVisibility(GONE);
                }
            } else if (attr == R.styleable.ItemEditView_leftSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(40));
                LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) leftImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                leftImageView.setLayoutParams(layoutParams);

            } else if (attr == R.styleable.ItemEditView_titleValue) {
                titleTextView.setText(typedArray.getString(attr));
            } else if (attr == R.styleable.ItemEditView_titleValueSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, dp2px(18));
                titleTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.ItemEditView_titleValueColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                titleTextView.setTextColor(color);
            } else if (attr == R.styleable.ItemEditView_input) {
                String desc = typedArray.getString(attr);
                if (!TextUtils.isEmpty(desc)) {
                    inputTextView.setVisibility(VISIBLE);
                    inputTextView.setText(desc);
                }
            } else if (attr == R.styleable.ItemEditView_inputHint) {
                String descHint = typedArray.getString(attr);
                if (!TextUtils.isEmpty(descHint)) {
                    inputTextView.setVisibility(VISIBLE);
                    inputTextView.setHint(descHint);
                }
            } else if (attr == R.styleable.ItemEditView_inputSize) {
                float textSize = typedArray.getDimensionPixelSize(attr, dp2px(18));
                inputTextView.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSize);
            } else if (attr == R.styleable.ItemEditView_inputColor) {
                int color = typedArray.getColor(attr, Color.BLACK);
                inputTextView.setTextColor(color);
            } else if (attr == R.styleable.ItemEditView_rightIcon) {
                int resId = typedArray.getResourceId(attr, 0);
                if (resId != 0) {
                    rightImageView.setImageResource(resId);
                    rightImageView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.ItemEditView_rightSize) {
                int dimension = typedArray.getDimensionPixelSize(attr, dp2px(40));
                LayoutParams layoutParams = (LayoutParams) rightImageView.getLayoutParams();
                layoutParams.width = dimension;
                layoutParams.height = dimension;
                rightImageView.setLayoutParams(layoutParams);
            } else if (attr == R.styleable.ItemEditView_line) {
                boolean aBoolean = typedArray.getBoolean(attr, false);
                if (aBoolean) {
                    dividerView.setVisibility(VISIBLE);
                }
            } else if (attr == R.styleable.ItemEditView_lineColor) {
                dividerView.setBackgroundColor(typedArray.getColor(attr, Color.BLACK));
            }

        }
        typedArray.recycle();
    }

    public ImageView getLeftImageView() {
        return leftImageView;
    }

    public TextView getTitleView() {
        return titleTextView;
    }

    public EditText getInputView() {
        return inputTextView;
    }

    public ImageView getRightImageView() {
        return rightImageView;
    }

    public void setTitle(String title) {
        if (titleTextView != null) {
            titleTextView.setText(title);
            leftImageView.setVisibility(VISIBLE);
        }
    }

    public String getTitle() {
        if (titleTextView != null) {
            titleTextView.getText().toString();
        }
        return null;
    }

    public void setInput(String desc) {
        if (inputTextView != null) {
            if (TextUtils.isEmpty(desc)) {
                inputTextView.setVisibility(GONE);
            } else {
                inputTextView.setVisibility(VISIBLE);
                inputTextView.setText(desc);
            }
        }
    }

    public String getInput() {
        if (inputTextView != null) {
            return inputTextView.getText().toString();
        }
        return null;
    }


    public void setLineVisibility(int visibility) {
        if (dividerView != null) {
            dividerView.setVisibility(visibility);
        }
    }

    private int dp2px(int dip) {
        float density = getContext().getResources().getDisplayMetrics().density;
        return (int) (dip * density + 0.5f);
    }

    private int px2dp(float pxValue) {
        final float scale = getContext().getResources().getDisplayMetrics().density;
        return (int) (pxValue / scale + 0.5f);
    }
}