package cn.lsmya.activity;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;

import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;

import cn.lsmya.loading.LoadingView;

public abstract class BaseActivity extends AppCompatActivity implements Interface {

    private Dialog loadingDialog;
    private Toolbar toolbar;
    private TextView titleView;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(getLayoutId());
        initBar();
        getIntentExtra();
        initView();
        addListeners();
    }

    @Override
    public void setTitle(CharSequence title) {
        if (toolbar != null) {
            toolbar.setTitle(title);
        }
    }

    @Override
    public void setTitle(int titleId) {
        if (toolbar != null) {
            toolbar.setTitle(titleId);
        }
    }

    public void setCenterTitle(CharSequence title) {
        if (titleView != null) {
            titleView.setText(title);
        }
    }

    public void setCenterTitle(int titleId) {
        if (titleView != null) {
            titleView.setText(titleId);
        }
    }

    public boolean showBar() {
        return true;
    }

    public void showLoadingDialog(boolean show) {
        if (loadingDialog == null) {
            loadingDialog = new Dialog(this);
        }
        loadingDialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        loadingDialog.getWindow().setDimAmount(0f);
        loadingDialog.setCanceledOnTouchOutside(false);
        LoadingView loadingView = new LoadingView(this);
        loadingView.setColor(Color.GRAY);
        loadingView.setSize(70);
        loadingDialog.setContentView(loadingView);
        if (show) {
            if (!loadingDialog.isShowing()) {
                loadingDialog.show();
            }
        } else {
            if (loadingDialog.isShowing()) {
                loadingDialog.dismiss();
            }
        }
    }

    protected void setOnClickListener(@IdRes int id, View.OnClickListener onClickListener) {
        findViewById(id).setOnClickListener(onClickListener);
    }

    protected void setOnLongClickListener(@IdRes int id, View.OnLongClickListener onClickListener) {
        findViewById(id).setOnLongClickListener(onClickListener);
    }

    private void initBar() {
        toolbar = findViewById(R.id.helper_toolbar_toolbar);
        titleView = findViewById(R.id.helper_toolbar_title);
        if (toolbar != null) {
            setSupportActionBar(toolbar);
            toolbar.setNavigationIcon(R.drawable.helper_arrow_back);
        }
        if (titleView != null) {
            titleView.setTextColor(getTheme().obtainStyledAttributes(new int[]{android.R.attr.textColorPrimary}).getColor(0, 0xFF00FF));
        }
        if (getSupportActionBar() != null) {
            getSupportActionBar().setDisplayHomeAsUpEnabled(true);
            getSupportActionBar().setTitle(null);
        }
    }

    protected void getIntentExtra() {
    }

    /**
     * 隐藏软键盘
     */
    protected void hideInputMethod(EditText v) {
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(v.getWindowToken(), 0);
    }

    /**
     * 显示软键盘
     */
    protected void showInputMethod(EditText v) {
        v.requestFocus();
        InputMethodManager imm = (InputMethodManager) getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.showSoftInput(v, InputMethodManager.SHOW_IMPLICIT);
    }

    protected void goActivity(Class cls) {
        Intent intent = new Intent(this, cls);
        startActivity(intent);
    }

    protected void goActivityForResult(Class cls, int requestCode) {
        Intent intent = new Intent(this, cls);
        startActivityForResult(intent, requestCode);
    }

    @Override
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            finish();
            return false;
        }
        return super.onOptionsItemSelected(item);
    }
}
