package cn.lsmya.activity;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

public abstract class BaseFragment extends LazyFragment {

    @Override
    @LayoutRes
    protected abstract int getLayoutId();

    @Nullable
    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        findView();
        initView();
        return super.onCreateView(inflater, container, savedInstanceState);
    }

    /**
     * 绑定控件
     */
    protected void findView() {
    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

}
