package cn.lsmya.activity.mvp;

import android.app.Dialog;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import java.lang.reflect.ParameterizedType;

import cn.lsmya.activity.LazyFragment;
import cn.lsmya.loading.LoadingView;

public abstract class BaseMvpFragment<P extends BaseMvpPresenter, M> extends LazyFragment implements BaseMvpView {

    private Dialog loadingDialog;

    private P mPresenter;
    private M mModel;

    @Override
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        mPresenter = getT(this, 0);
        mModel = getT(this, 1);
        if (getPresenter() != null && mModel != null) {
            getPresenter().attachView(this, mModel);
        }
        findView();
        initView();
    }

    /**
     * 绑定控件
     */
    protected void findView() {

    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

    @Override
    public void onDestroy() {
        if (getPresenter() != null) {
            getPresenter().detachView();
        }
        super.onDestroy();
    }

    public P getPresenter() {
        return mPresenter;
    }

    private <T> T getT(Object o, int i) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType) o.getClass().getGenericSuperclass();
            Class<T> actualTypeArgument = (Class<T>) parameterizedType.getActualTypeArguments()[i];
            return actualTypeArgument.newInstance();
        } catch (java.lang.InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (ClassCastException e) {
            e.printStackTrace();
        }
        return null;
    }
    public void showLoadingDialog(boolean show) {
        if (loadingDialog == null) {
            loadingDialog = new Dialog(getActivity());
        }
        loadingDialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        loadingDialog.getWindow().setDimAmount(0f);
        loadingDialog.setCanceledOnTouchOutside(false);
        LoadingView loadingView = new LoadingView(getActivity());
        loadingView.setColor(Color.GRAY);
        loadingView.setSize(70);
        loadingDialog.setContentView(loadingView);
        if (show) {
            if (!loadingDialog.isShowing()) {
                loadingDialog.show();
            }
        } else {
            if (loadingDialog.isShowing()) {
                loadingDialog.dismiss();
            }
        }
    }
}
