package cn.lsmya.activity.mvp;

import java.lang.reflect.ParameterizedType;

import cn.lsmya.activity.BaseActivity;

public abstract class BaseMvpActivity<P extends BaseMvpPresenter, M> extends BaseActivity implements BaseMvpView {

    private P mPresenter;
    private M mModel;

    @Override
    protected void initMvp() {
        super.initMvp();
        mPresenter = getT(this, 0);
        mModel = getT(this, 1);
        if (getPresenter() != null && mModel != null) {
            getPresenter().attachView(this, mModel);
        }
    }

    @Override
    protected void onDestroy() {
        if (getPresenter() != null) {
            getPresenter().detachView();
        }
        super.onDestroy();
    }

    public P getPresenter() {
        return mPresenter;
    }
    private <T> T getT(Object o, int i) {
        try {
            ParameterizedType parameterizedType = (ParameterizedType) o.getClass().getGenericSuperclass();
            Class<T> actualTypeArgument = (Class<T>) parameterizedType.getActualTypeArguments()[i];
            return actualTypeArgument.newInstance();
        } catch (java.lang.InstantiationException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (ClassCastException e) {
            e.printStackTrace();
        }
        return null;
    }
}