package cn.lsmya.activity;

import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.EditText;
import android.widget.FrameLayout;

public abstract class SplashActivity extends BaseActivity {

    @Override
    public abstract int getLayoutId();

    public abstract Animation.AnimationListener getAnimationListener();

    protected Animation getAnimation() {
        return AnimationUtils.loadAnimation(this, R.anim.helper_splash);
    }

    protected void startAnimation(View rootView) {
        Animation anim = getAnimation();
        anim.setAnimationListener(getAnimationListener());
        rootView.startAnimation(anim);
    }

    @Override
    public void initView() {
        setContentView(getLayoutId());
        startAnimation(getContentView());
    }

    private View getContentView() {
        ViewGroup view = (ViewGroup) getWindow().getDecorView();
        FrameLayout content = view.findViewById(android.R.id.content);
        return content.getChildAt(0);
    }

    @Override
    public void hideInputMethod(EditText v) {
        super.hideInputMethod(v);
    }
}
