package cn.lsmya.activity;

import android.app.Dialog;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.LayoutRes;
import androidx.annotation.Nullable;

import cn.lsmya.loading.LoadingView;

public abstract class BaseFragment extends LazyFragment {

    private Dialog loadingDialog;

    @Override
    @LayoutRes
    protected abstract int getLayoutId();

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        findView();
        initView();
    }

    /**
     * 绑定控件
     */
    protected void findView() {
    }

    /**
     * 初始化控件
     */
    protected abstract void initView();

    public void showLoadingDialog(boolean show) {
        if (loadingDialog == null) {
            loadingDialog = new Dialog(getActivity());
        }
        loadingDialog.getWindow().setBackgroundDrawableResource(android.R.color.transparent);
        loadingDialog.getWindow().setDimAmount(0f);
        loadingDialog.setCanceledOnTouchOutside(false);
        LoadingView loadingView = new LoadingView(getActivity());
        loadingView.setColor(Color.GRAY);
        loadingView.setSize(70);
        loadingDialog.setContentView(loadingView);
        if (show) {
            if (!loadingDialog.isShowing()) {
                loadingDialog.show();
            }
        } else {
            if (loadingDialog.isShowing()) {
                loadingDialog.dismiss();
            }
        }
    }
}
