package humm.android.api.Deserializers;

import android.util.Log;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

import humm.android.api.Model.Song;

/**
 * Created by josealonsogarcia on 19/1/16.
 */
public class SongDeserializer implements JsonDeserializer<Song> {
    @Override
    public Song deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {

        JsonObject jobject = (JsonObject) json;

        String title = jobject.get("title") != null ? jobject.get("title").getAsString() : null;
        String description = jobject.get("description") != null ? jobject.get("description").getAsString() : null;
        String type = jobject.get("type") != null ? jobject.get("type").getAsString() : null;
        String date = jobject.get("date") != null ? jobject.get("date").getAsString() : null;
        HashMap urls = context.deserialize(jobject.get("urls"), HashMap.class);
        List<HashMap<String, String>> artists = context.deserialize(jobject.get("artists"), List.class);
        List<HashMap> playlists = context.deserialize(jobject.get("playlists"), List.class);

        if (playlists != null && playlists.size() > 10) {
            playlists = playlists.subList(0, 10);
        }
        HashMap<String, String> foreign_ids = context.deserialize(jobject.get("foreign_ids"), HashMap.class);
        HashMap<String, String> stats = context.deserialize(jobject.get("stats"), HashMap.class);
        List contributors = context.deserialize(jobject.get("contributors"), List.class);
        List stories = context.deserialize(jobject.get("stories"), List.class);
        List genres = context.deserialize(jobject.get("genres"), List.class);

        return new Song(title, description, type, date, urls, artists, playlists, foreign_ids, stats, contributors, stories, genres);
    }
}
