package android.dev.support.recycler.simple.adapter;

import android.dev.support.recycler.adapter.caller.TypeDependent;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.simple.SimpleSuccinctPool;
import android.dev.support.recycler.simple.holder.SimpleViewTypeHolder;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public final class RecyclerAdapterFactory {

    public static <D> SimpleSuccinctPool<D> multiType(){
        return new SimpleSuccinctPool<>();
    }

    public static <D> SimpleSuccinctPool<D> multiType(TypeDependent<D,SimpleViewTypeHolder> typeDependent){
        return new SimpleSuccinctPool<>(typeDependent);
    }

    public static <D> SingleTypeBuilder<D> singleType(int layout){
        return new SingleTypeBuilder<>(layout);
    }

    public static <D> SingleTypeBuilder<D> singleType(ViewTypeCreator<SimpleViewTypeHolder> creator){
        return new SingleTypeBuilder<>(creator);
    }

}
