package android.dev.support.recycler.simple;

import android.content.Context;
import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.SuccinctViewAdapter;
import android.dev.support.recycler.adapter.binder.ViewTypeBinder;
import android.dev.support.recycler.adapter.caller.SuccinctPool;
import android.dev.support.recycler.adapter.caller.TypeDecider;
import android.dev.support.recycler.adapter.caller.TypeDependent;
import android.dev.support.recycler.adapter.caller.ViewInjector;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.listener.ViewEventPerformer;
import android.dev.support.recycler.simple.adapter.SimpleSuccinctViewAdapter;
import android.dev.support.recycler.simple.binder.SimpleViewTypeBinder;
import android.dev.support.recycler.simple.holder.SimpleViewTypeHolder;
import android.support.v4.widget.Space;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SimpleSuccinctPool<D> extends SuccinctPool<D, SimpleViewTypeHolder> {

    private final static ViewTypeCreator<SimpleViewTypeHolder> mSimpleViewTypeCreator = new ViewTypeCreator<SimpleViewTypeHolder>() {
        @Override
        public SimpleViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
            Context context = parent.getContext();
            Space space = new Space(context);
            space.setLayoutParams(new ViewGroup.LayoutParams(0, 0));
            return new SimpleViewTypeHolder(space);
        }
    };

    public SimpleSuccinctPool() {
    }

    public SimpleSuccinctPool(TypeDependent<D, SimpleViewTypeHolder> typeDependent) {
        super(typeDependent);
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId) {
        super.register(layoutId);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, TypeDecider<D> decider) {
        super.register(layoutId, decider);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, TypeDecider<D> decider, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(layoutId, decider, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, ViewEventPerformer<SimpleViewTypeHolder> performer) {
        super.register(layoutId, performer);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, TypeDecider<D> decider, ViewEventPerformer<SimpleViewTypeHolder> performer) {
        super.register(layoutId, decider, performer);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(layoutId, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(layoutId, performer, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, ViewTypeInjector<D, SimpleViewTypeHolder> injector) {
        super.register(layoutId, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(int layoutId, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewTypeInjector<D, SimpleViewTypeHolder> injector) {
        super.register(layoutId, performer, injector);
        return this;
    }


    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator) {
        super.register(creator);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, TypeDecider<D> decider) {
        super.register(creator, decider);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, TypeDecider<D> decider, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(creator, decider, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, ViewEventPerformer<SimpleViewTypeHolder> performer) {
        super.register(creator, performer);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, TypeDecider<D> decider, ViewEventPerformer<SimpleViewTypeHolder> performer) {
        super.register(creator, decider, performer);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(creator, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewInjector<D, SimpleViewTypeHolder> injector) {
        super.register(creator, performer, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, ViewTypeInjector<D, SimpleViewTypeHolder> injector) {
        super.register(creator, injector);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewTypeInjector<D, SimpleViewTypeHolder> injector) {
        super.register(creator, performer, injector);
        return this;
    }

    @Override
    public SimpleSuccinctViewAdapter<D> adapt() {
        return new SimpleSuccinctViewAdapter<>(this);
    }

    @Override
    public SimpleSuccinctPool<D> register(int viewTypeLayout, ViewTypeInjector<D, SimpleViewTypeHolder> viewTypeInjector, ViewHolderMonitor<D, SimpleViewTypeHolder> monitor) {
        super.register(viewTypeLayout, viewTypeInjector, monitor);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(final int layoutId, TypeDecider<D> decider, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewInjector<D, SimpleViewTypeHolder> injector, ViewHolderMonitor<D, SimpleViewTypeHolder> monitor) {
        ViewTypeCreator<SimpleViewTypeHolder> creator = new ViewTypeCreator<SimpleViewTypeHolder>() {
            @Override
            public SimpleViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
                return SimpleViewTypeHolder.inflate(layoutId,parent);
            }
        };

        return register(creator,decider,performer,injector,monitor);
    }


    @Override
    public SimpleSuccinctPool<D> register(ViewTypeCreator<SimpleViewTypeHolder> creator, TypeDecider<D> decider, ViewEventPerformer<SimpleViewTypeHolder> performer, ViewInjector<D, SimpleViewTypeHolder> injector, ViewHolderMonitor<D, SimpleViewTypeHolder> monitor) {
        super.register(creator, decider, performer, injector, monitor);
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> register(ViewTypeBinder<D, SimpleViewTypeHolder> binder) {
        super.register(binder);
        return this;
    }
    @Override
    public SimpleSuccinctPool<D> unregister(int key) {
        super.unregister(key);
        return this;
    }
    @Override
    public SimpleSuccinctPool<D> reset() {
        super.reset();
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> enableUnknownViewType() {
        super.enableUnknownViewType();
        return this;
    }

    @Override
    public SimpleSuccinctPool<D> enableUnknownViewType(ViewTypeBinder<D, SimpleViewTypeHolder> binder) {
        super.enableUnknownViewType(binder);
        return this;
    }

    @Override
    protected ViewTypeCreator<SimpleViewTypeHolder> provideUnknownViewTypeCreator() {
        return mSimpleViewTypeCreator;
    }

}
