package android.dev.support.recycler.simple.adapter;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.ViewInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.simple.holder.SimpleViewTypeHolder;
import android.support.annotation.LayoutRes;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SingleTypeBuilder<D> {

    private final ViewTypeCreator<SimpleViewTypeHolder> mCreator;

    private ViewInjector<D,SimpleViewTypeHolder> mInjector;

    private ViewHolderMonitor<D,SimpleViewTypeHolder> mMonitor;


    public SingleTypeBuilder(@LayoutRes final int layout) {
        mCreator = new ViewTypeCreator<SimpleViewTypeHolder>() {
            @Override
            public SimpleViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
                return SimpleViewTypeHolder.inflate(layout,parent);
            }
        };
    }

    public SingleTypeBuilder(ViewTypeCreator<SimpleViewTypeHolder> creator) {
        mCreator = creator;
    }

    public SingleTypeBuilder<D> bind(ViewInjector<D,SimpleViewTypeHolder> injector){
        mInjector = injector;
        return this;
    }

    public SingleTypeBuilder<D> monitor(ViewHolderMonitor<D,SimpleViewTypeHolder> monitor){
        mMonitor = monitor;
        return this;
    }

    ViewTypeCreator<SimpleViewTypeHolder> getCreator(){
        return mCreator;
    }

    ViewInjector<D,SimpleViewTypeHolder> getInjector(){
        return mInjector;
    }

    ViewHolderMonitor<D,SimpleViewTypeHolder> getMonitor(){
        return mMonitor;
    }

    public SingleTypeViewAdapter<D> adapt(){
        return new SingleTypeViewAdapter<>(this);
    }


}
