package android.dev.support.recycler.simple.holder;

import android.content.Context;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SimpleViewTypeHolder extends ViewTypeHolder {

    private SparseArray<View> mCaches;

    public SimpleViewTypeHolder(View itemView) {
        super(itemView);
    }
    public static SimpleViewTypeHolder inflate(LayoutInflater inflater, @LayoutRes int layout, ViewGroup parent){
        View itemView = inflater.inflate(layout,parent,false);
        return new SimpleViewTypeHolder(itemView);
    }
    public static SimpleViewTypeHolder inflate(@LayoutRes int layout, ViewGroup parent){
        View itemView = LayoutInflater.from(parent.getContext()).inflate(layout,parent,false);
        return new SimpleViewTypeHolder(itemView);
    }
    public static SimpleViewTypeHolder inflate(Context context, @LayoutRes int layout, ViewGroup parent){
        View itemView = LayoutInflater.from(context).inflate(layout,parent,false);
        return new SimpleViewTypeHolder(itemView);
    }

    public ViewTypeHolder image(@IdRes int viewId, @DrawableRes int imageResId) {
        ImageView view = find(viewId);
        view.setImageResource(imageResId);
        return this;

    }
    public ViewTypeHolder image(@IdRes int viewId, Drawable drawable) {
        ImageView view = find(viewId);
        view.setImageDrawable(drawable);
        return this;
    }

    public ViewTypeHolder label(@IdRes int viewId,String data){
        findLabelView(viewId).setText(data);
        return this;
    }

    public ViewTypeHolder backgroundColor(@IdRes int viewId, int color) {
        View view = find(viewId);
        view.setBackgroundColor(color);
        return this;

    }

    public ViewTypeHolder backgroundRes(@IdRes int viewId, @DrawableRes int backgroundRes) {
        View view = find(viewId);
        view.setBackgroundResource(backgroundRes);
        return this;
    }

    public ViewTypeHolder textColor(@IdRes int viewId, int textColor) {
        TextView view = find(viewId);
        view.setTextColor(textColor);
        return this;

    }

    public ViewTypeHolder alpha(@IdRes int viewId, float value) {
        find(viewId).setAlpha(value);
        return this;
    }

    public ViewTypeHolder visibility(@IdRes int viewId, boolean visible) {
        View view = find(viewId);
        view.setVisibility(visible ? View.VISIBLE : View.GONE);
        return this;
    }

    public ViewTypeHolder visibility(@IdRes int viewId,int visibility) {
        View view = find(viewId);
        view.setVisibility(visibility);
        return this;
    }

    public ViewTypeHolder click(@IdRes int viewId, View.OnClickListener listener) {
        View view = find(viewId);
        view.setOnClickListener(listener);
        return this;
    }

    public ViewTypeHolder checked(@IdRes int viewId, boolean checked) {

        View view = find(viewId);

        // View unable cast to Checkable

        if (view instanceof CompoundButton) {

            ((CompoundButton) view).setChecked(checked);

        } else if (view instanceof CheckedTextView) {

            ((CheckedTextView) view).setChecked(checked);

        }
        return this;

    }




    @SuppressWarnings("unchecked")
    public <T extends View> T find(@IdRes int id) {
        if(mCaches==null){
            mCaches = new SparseArray<>();
        }
        View view = mCaches.get(id);

        if (view == null) {
            view = itemView.findViewById(id);
            if(view==null){
                throw new IllegalArgumentException("can not find view for id :"+id);
            }
            mCaches.put(id, view);
        }

        return (T) view;

    }

    public TextView findLabelView(@IdRes int id){
        return find(id);
    }

    public ImageView findImageView(@IdRes int id){
        return find(id);
    }
}
