package android.dev.support.recycler.simple.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.RecyclerViewAdapter;
import android.dev.support.recycler.adapter.binder.ViewTypeBinder;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.simple.holder.SimpleViewTypeHolder;
import android.support.annotation.NonNull;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SimpleViewTypeBinder<D> extends ViewTypeBinder<D,SimpleViewTypeHolder> {

    public SimpleViewTypeBinder(ViewTypeInjector<D,SimpleViewTypeHolder> injector, int viewLayout) {
        super(injector, viewLayout, null, null);
    }

    public SimpleViewTypeBinder(ViewTypeInjector<D,SimpleViewTypeHolder> injector, int viewLayout, ViewHolderMonitor<D,SimpleViewTypeHolder> monitor) {
        super(injector, viewLayout, monitor, null);
    }

    public SimpleViewTypeBinder(ViewTypeInjector<D,SimpleViewTypeHolder> injector,@NonNull ViewTypeCreator<SimpleViewTypeHolder> creator) {
        super(injector, creator);
    }

    public SimpleViewTypeBinder(ViewTypeInjector<D,SimpleViewTypeHolder> injector, ViewHolderMonitor<D,SimpleViewTypeHolder> monitor,
                                @NonNull ViewTypeCreator<SimpleViewTypeHolder> creator) {
        super(injector, monitor, creator);
    }

    @NonNull
    @Override
    public SimpleViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        SimpleViewTypeHolder holder = super.onCreateViewHolder(adapter, parent);
        if (holder == null) {
            holder = SimpleViewTypeHolder.inflate(getItemViewLayout(), parent);
        }
        return holder;
    }
}
