package android.dev.support.recycler.simple;

import android.content.Context;
import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.RecyclerViewAdapter;
import android.dev.support.recycler.adapter.caller.SuccinctPool;
import android.dev.support.recycler.adapter.caller.TypeDependent;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.simple.adapter.SimpleSuccinctViewAdapter;
import android.dev.support.recycler.simple.binder.SimpleViewTypeBinder;
import android.dev.support.recycler.simple.holder.SimpleViewTypeHolder;
import android.support.v4.widget.Space;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SimpleSuccinctPool<D> extends SuccinctPool<D, SimpleViewTypeHolder> {

    private final static ViewTypeCreator<SimpleViewTypeHolder> mSimpleViewTypeCreator = new ViewTypeCreator<SimpleViewTypeHolder>() {
        @Override
        public SimpleViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
            Context context = parent.getContext();
            Space space = new Space(context);
            space.setLayoutParams(new ViewGroup.LayoutParams(0, 0));
            return new SimpleViewTypeHolder(space);
        }
    };

    public SimpleSuccinctPool() {
    }

    public SimpleSuccinctPool(TypeDependent<D, SimpleViewTypeHolder> typeDependent) {
        super(typeDependent);
    }

    @Override
    public SuccinctPool<D, SimpleViewTypeHolder> register(int viewTypeLayout, ViewTypeInjector<D,SimpleViewTypeHolder> viewTypeInjector) {
        SimpleViewTypeBinder<D> binder = new SimpleViewTypeBinder<>(viewTypeInjector, viewTypeLayout);
        return register(binder);
    }

    @Override
    public SuccinctPool<D, SimpleViewTypeHolder> register(int viewTypeLayout, ViewTypeInjector<D,SimpleViewTypeHolder> viewTypeInjector, ViewHolderMonitor<D,SimpleViewTypeHolder> monitor) {
        SimpleViewTypeBinder<D> binder = new SimpleViewTypeBinder<>(viewTypeInjector, viewTypeLayout, monitor);
        return register(binder);
    }

    @Override
    protected ViewTypeCreator<SimpleViewTypeHolder> provideUnknownViewTypeCreator() {
        return mSimpleViewTypeCreator;
    }

    @Override
    public SimpleSuccinctViewAdapter<D> adapt() {
        return new SimpleSuccinctViewAdapter<>(this);
    }
}
