package android.dev.support.recycler.bind.holder;

import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.annotation.LayoutRes;
import android.view.LayoutInflater;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/19 0019.
 */

public class BindViewTypeHolder extends ViewTypeHolder {

    private ViewDataBinding mBinding;

    public BindViewTypeHolder(ViewDataBinding binding) {
        super(binding.getRoot());
        mBinding = binding;
    }

    @SuppressWarnings("unchecked")
    public <B extends ViewDataBinding> B getBinding() {
        return (B) mBinding;
    }

    public static BindViewTypeHolder inflate(LayoutInflater inflater, @LayoutRes int layout, ViewGroup parent) {
        ViewDataBinding binding = DataBindingUtil.inflate(inflater, layout, parent, false);
        return new BindViewTypeHolder(binding);
    }

    public static BindViewTypeHolder inflate(@LayoutRes int layout, ViewGroup parent) {
        ViewDataBinding binding = DataBindingUtil.inflate(LayoutInflater.from(parent.getContext()), layout, parent, false);
        return new BindViewTypeHolder(binding);
    }
}
