package android.dev.support.recycler.bind.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.binder.ViewTypeBinder;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.bind.holder.BindViewTypeHolder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/19 0019.
 */

public class DataViewTypeBinder<D> extends ViewTypeBinder<D, BindViewTypeHolder> {

    public DataViewTypeBinder(ViewTypeInjector<D, BindViewTypeHolder> injector, int viewLayout) {
        super(injector, viewLayout, null, null);
    }

    public DataViewTypeBinder(ViewTypeInjector<D, BindViewTypeHolder> injector, int viewLayout, ViewHolderMonitor<D, BindViewTypeHolder> monitor) {
        super(injector, viewLayout, monitor, null);
    }

    public DataViewTypeBinder(ViewTypeInjector<D, BindViewTypeHolder> injector, @NonNull ViewTypeCreator<BindViewTypeHolder> creator) {
        super(injector, creator);
    }

    public DataViewTypeBinder(ViewTypeInjector<D, BindViewTypeHolder> injector, ViewHolderMonitor<D, BindViewTypeHolder> monitor, @NonNull ViewTypeCreator<BindViewTypeHolder> creator) {
        super(injector, monitor, creator);
    }

    @Nullable
    @Override
    public BindViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        BindViewTypeHolder holder = super.onCreateViewHolder(adapter, parent);
        if (holder == null) {
            holder = BindViewTypeHolder.inflate(getItemViewLayout(), parent);
        }
        return holder;
    }
}
