package android.dev.support.recycler.bind.adapter;

import android.dev.support.recycler.adapter.RecyclerViewAdapter;
import android.dev.support.recycler.adapter.caller.RecyclerItemClickListener;
import android.dev.support.recycler.adapter.caller.ViewInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.bind.holder.BindViewTypeHolder;
import android.view.ViewGroup;

import java.util.List;

/**
 * Created by wbs on 2017/9/1 0001.
 */

public class SingleTypeViewAdapter<T> extends RecyclerViewAdapter<T,BindViewTypeHolder> {

    private final ViewTypeCreator<BindViewTypeHolder> mViewTypeCreator;

    private final ViewInjector<T,BindViewTypeHolder> mInjector;

    private final ViewHolderMonitor<T,BindViewTypeHolder> mMonitor;


    protected SingleTypeViewAdapter(SingleTypeBuilder<T> builder){
        mViewTypeCreator = builder.getCreator();
        mInjector = builder.getInjector();
        mMonitor = builder.getMonitor();
    }

    @Override
    protected final BindViewTypeHolder createItemViewHolder(ViewGroup parent, int viewType) {
        return mViewTypeCreator.onCreateViewHolder(this,parent);
    }

    @Override
    public final void onBindViewHolder(BindViewTypeHolder holder, int position, List<Object> payloads) {
        if(mInjector!=null){
            mInjector.onBindViewHolder(this,position,holder,payloads);
        }
    }

    @Override
    public void onViewRecycled(BindViewTypeHolder holder) {
        if(mInjector!=null){
            mInjector.onUnbindViewHolder(this,holder);
        }
    }

    @Override
    public void onViewAttachedToWindow(BindViewTypeHolder holder) {

        if(mMonitor!=null){
            mMonitor.onAttachToWindow(this,holder);
        }
    }

    @Override
    public void onViewDetachedFromWindow(BindViewTypeHolder holder) {
        if(mMonitor!=null){
            mMonitor.onDetachFromWindow(this,holder);
        }
    }

    @Override
    public boolean onFailedToRecycleView(BindViewTypeHolder holder) {
        return super.onFailedToRecycleView(holder);
    }

    @Override
    public SingleTypeViewAdapter<T> setItemClickListener(RecyclerItemClickListener listener) {
        super.setItemClickListener(listener);
        return this;
    }

    @Override
    public int getItemViewType(int position) {
        return 0;
    }


}
