package android.dev.support.recycler.bind.adapter;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.ViewInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.bind.holder.BindViewTypeHolder;
import android.support.annotation.LayoutRes;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class SingleTypeBuilder<D> {

    private final ViewTypeCreator<BindViewTypeHolder> mCreator;

    private ViewInjector<D,BindViewTypeHolder> mInjector;

    private ViewHolderMonitor<D,BindViewTypeHolder> mMonitor;


    public SingleTypeBuilder(@LayoutRes final int layout) {
        mCreator = new ViewTypeCreator<BindViewTypeHolder>() {
            @Override
            public BindViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
                return BindViewTypeHolder.inflate(layout,parent);
            }
        };
    }

    public SingleTypeBuilder(ViewTypeCreator<BindViewTypeHolder> creator) {
        mCreator = creator;
    }

    public SingleTypeBuilder<D> bind(ViewInjector<D,BindViewTypeHolder> injector){
        mInjector = injector;
        return this;
    }

    public SingleTypeBuilder<D> monitor(ViewHolderMonitor<D,BindViewTypeHolder> monitor){
        mMonitor = monitor;
        return this;
    }

    ViewTypeCreator<BindViewTypeHolder> getCreator(){
        return mCreator;
    }

    ViewInjector<D,BindViewTypeHolder> getInjector(){
        return mInjector;
    }

    ViewHolderMonitor<D,BindViewTypeHolder> getMonitor(){
        return mMonitor;
    }

    public SingleTypeViewAdapter<D> adapt(){
        return new SingleTypeViewAdapter<>(this);
    }


}
