package android.dev.support.recycler.bind.adapter;

import android.dev.support.recycler.adapter.caller.TypeDependent;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.bind.BindSuccinctPool;
import android.dev.support.recycler.bind.holder.BindViewTypeHolder;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public final class RecyclerAdapterFactory {

    public static <D> BindSuccinctPool<D> multiType(){
        return new BindSuccinctPool<>();
    }

    public static <D> BindSuccinctPool<D> multiType(TypeDependent<D,BindViewTypeHolder> typeDependent){
        return new BindSuccinctPool<>(typeDependent);
    }

    public static <D> SingleTypeBuilder<D> singleType(int layout){
        return new SingleTypeBuilder<>(layout);
    }

    public static <D> SingleTypeBuilder<D> singleType(ViewTypeCreator<BindViewTypeHolder> creator){
        return new SingleTypeBuilder<>(creator);
    }

}
