package android.dev.support.recycler.bind;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.SuccinctPool;
import android.dev.support.recycler.adapter.caller.TypeDependent;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.bind.adapter.BindSuccinctViewAdapter;
import android.dev.support.recycler.bind.binder.DataViewTypeBinder;
import android.dev.support.recycler.bind.holder.BindViewTypeHolder;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class BindSuccinctPool<D> extends SuccinctPool<D, BindViewTypeHolder> {

    private final static ViewTypeCreator<BindViewTypeHolder> mBindViewTypeCreator = new ViewTypeCreator<BindViewTypeHolder>() {
        @Override
        public BindViewTypeHolder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
            return BindViewTypeHolder.inflate(R.layout.bind_item_space, parent);
        }
    };

    public BindSuccinctPool() {
    }

    public BindSuccinctPool(TypeDependent<D, BindViewTypeHolder> typeDependent) {
        super(typeDependent);
    }

    @Override
    public SuccinctPool<D, BindViewTypeHolder> register(int viewTypeLayout, ViewTypeInjector<D, BindViewTypeHolder> viewTypeInjector) {
        DataViewTypeBinder<D> binder = new DataViewTypeBinder<>(viewTypeInjector, viewTypeLayout);
        return register(binder);
    }

    @Override
    public SuccinctPool<D, BindViewTypeHolder> register(int viewTypeLayout, ViewTypeInjector<D, BindViewTypeHolder> viewTypeInjector, ViewHolderMonitor<D, BindViewTypeHolder> monitor) {
        DataViewTypeBinder<D> binder = new DataViewTypeBinder<>(viewTypeInjector, viewTypeLayout, monitor);
        return register(binder);
    }

    @Override
    protected ViewTypeCreator<BindViewTypeHolder> provideUnknownViewTypeCreator() {
        return mBindViewTypeCreator;
    }

    @Override
    public BindSuccinctViewAdapter<D> adapt() {
        return new BindSuccinctViewAdapter<>(this);
    }
}
