package android.dev.support.recycler.adapter.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.annotation.NonNull;
import android.view.ViewGroup;

import java.util.List;

/**
 * Created on 2018/6/20
 *
 * @author wenbosheng
 * Copyright (c) 2018 Amber
 */
public abstract class AbstractBinder<D, Holder extends ViewTypeHolder> {

    public boolean typeOf(RecyclerAdapter<D> adapter, int position) {
        return true;
    }


    public abstract void onBindViewHolder(RecyclerAdapter<D> adapter, int position, @NonNull Holder holder, List<Object> payloads);

    public void onUnbindViewHolder(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    public final Holder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        Holder holder = onCreateViewTypeHolder(adapter,parent);
        onPerformViewHolderEvent(adapter,holder,parent);
        return holder;
    }

    public void onAttachToWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    public void onDetachFromWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    protected abstract Holder onCreateViewTypeHolder(RecyclerAdapter<?> adapter, ViewGroup parent);

    protected void onPerformViewHolderEvent(RecyclerAdapter<?> adapter,Holder holder,ViewGroup parent){

    }
}
