package android.dev.support.recycler.adapter.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.annotation.NonNull;
import android.view.ViewGroup;

/**
 * Created on 2018/6/20
 *
 * @author wenbosheng
 * Copyright (c) 2018 Amber
 */
public abstract class AbstractBinder<D, Holder extends ViewTypeHolder> implements ViewHolderMonitor<D, Holder>,
        ViewTypeCreator<Holder>, ViewTypeInjector<D, Holder> {
    @Override
    public boolean typeOf(RecyclerAdapter<D> adapter, int position) {
        return true;
    }


    @Override
    public void onUnbindViewHolder(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    @Override
    public final Holder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        Holder holder = onCreateViewTypeHolder(adapter,parent);
        onPerformViewHolderEvent(adapter,holder,parent);
        return holder;
    }

    @Override
    public void onAttachToWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    @Override
    public void onDetachFromWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {

    }

    protected abstract Holder onCreateViewTypeHolder(RecyclerAdapter<?> adapter, ViewGroup parent);

    protected void onPerformViewHolderEvent(RecyclerAdapter<?> adapter,Holder holder,ViewGroup parent){

    }
}
