package android.dev.support.recycler.gesture;

import android.content.res.Resources;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;
import android.util.TypedValue;
import android.view.View;


import static android.support.v7.widget.helper.ItemTouchHelper.ANIMATION_TYPE_DRAG;
import static android.support.v7.widget.helper.ItemTouchHelper.Callback.DEFAULT_DRAG_ANIMATION_DURATION;

/**
 * Created by oeager on 2016/11/23.
 */

public class UndoItemEffectProvider implements ItemEffectProvider {

    private Drawable mDrawable;

    private final int mDp16;

    private Paint mPaint;

    public UndoItemEffectProvider(Drawable delIcon, int delBgColor) {
        mDp16 = (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP,
                16, Resources.getSystem().getDisplayMetrics());
        mDrawable = delIcon;
        mPaint = new Paint();
        mPaint.setColor(delBgColor);
    }


    @Override
    public boolean requestViewHolderSameType() {
        return true;
    }

    @Override
    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != ItemTouchHelper.ACTION_STATE_IDLE) {
            if (viewHolder instanceof ViewTypeHolder) {
                ((ViewTypeHolder) viewHolder).onItemViewSelected();
            }
        }

    }

    @Override
    public void onClearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof ViewTypeHolder) {
            ((ViewTypeHolder) viewHolder).onClearItemView(recyclerView);
        }
    }

    @Override
    public long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
        return animationType == ANIMATION_TYPE_DRAG ? DEFAULT_DRAG_ANIMATION_DURATION : 350;
    }

    @Override
    public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
        return 0.1f;
    }

    @Override
    public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
        return 0.9f;
    }

    @Override
    public void onSwipeChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        View itemView = viewHolder.itemView;
        if (dX > 0) {
            c.drawRect(itemView.getLeft(), itemView.getTop(), dX, itemView.getBottom(), mPaint);
            int top = itemView.getTop() + (itemView.getBottom() - itemView.getTop() - mDrawable.getIntrinsicHeight()) / 2;
            int left = itemView.getLeft() + mDp16;
            mDrawable.setBounds(left, top, left + mDrawable.getIntrinsicWidth(), top + mDrawable.getIntrinsicHeight());
            mDrawable.draw(c);
        } else if (dX < 0) {
            c.drawRect(itemView.getRight() + dX, itemView.getTop(), itemView.getRight(), itemView.getBottom(), mPaint);
            int top = itemView.getTop() + (itemView.getBottom() - itemView.getTop() - mDrawable.getIntrinsicHeight()) / 2;
            int right = itemView.getRight() - mDp16;
            int left = right - mDrawable.getIntrinsicWidth();
            mDrawable.setBounds(left, top, right, top + mDrawable.getIntrinsicHeight());
            mDrawable.draw(c);
        }
    }
}
