/*
 * Copyright 2016 Yan Zhenjie
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package android.dev.support.recycler.gesture;

import android.graphics.Canvas;
import android.support.v7.widget.RecyclerView;

/**
 * Created by Yan Zhenjie on 2016/8/12.
 */
public interface ItemEffectProvider {

    int THRESHOLD_INVALIDATE =-1;

    int ANIMATION_DURATION_INVALIDATE = -1;

    boolean requestViewHolderSameType();

    void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState);

    void onClearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder);

    long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy);

    float getMoveThreshold(RecyclerView.ViewHolder viewHolder);

    float getSwipeThreshold(RecyclerView.ViewHolder viewHolder);

    void onSwipeChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive);


}
