package android.dev.support.recycler.gesture;

import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.graphics.Canvas;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;


/**
 * Created by oeager on 2016/11/23.
 */

public class DefaultItemEffectProvider implements ItemEffectProvider {
    @Override
    public boolean requestViewHolderSameType() {
        return false;
    }

    @Override
    public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
        if (actionState != ItemTouchHelper.ACTION_STATE_IDLE) {
            if(viewHolder instanceof ViewTypeHolder){
                ((ViewTypeHolder) viewHolder).onItemViewSelected();
            }
        }
    }

    @Override
    public void onClearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
        if(viewHolder instanceof ViewTypeHolder){
            ((ViewTypeHolder) viewHolder).onClearItemView(recyclerView);
        }
    }

    @Override
    public long getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
        return ANIMATION_DURATION_INVALIDATE;
    }

    @Override
    public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
        return THRESHOLD_INVALIDATE;
    }

    @Override
    public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
        return THRESHOLD_INVALIDATE;
    }

    @Override
    public void onSwipeChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        float alpha = 1;
        if (layoutManager instanceof LinearLayoutManager) {
            int orientation = ((LinearLayoutManager) layoutManager).getOrientation();
            if (orientation == LinearLayoutManager.HORIZONTAL) {
                alpha = 1 - Math.abs(dY) / viewHolder.itemView.getHeight();
            } else if (orientation == LinearLayoutManager.VERTICAL) {
                alpha = 1 - Math.abs(dX) / viewHolder.itemView.getWidth();
            }
        }
        viewHolder.itemView.setAlpha(alpha);//1~0
    }
}
