package android.dev.support.recycler.adapter.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.TypeDecider;
import android.dev.support.recycler.adapter.caller.ViewInjector;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.dev.support.recycler.adapter.listener.ViewEventPerformer;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;

import java.util.List;

/**
 * Created by wbs on 2017/8/30 0030.
 */

public class ViewTypeBinder<D,Holder extends ViewTypeHolder> implements ViewHolderMonitor<D,Holder>,
        ViewTypeCreator<Holder>, ViewTypeInjector<D,Holder> {

    private final ViewHolderMonitor<D,Holder> mMonitor;

    private final ViewInjector<D,Holder> mInjector;

    private final ViewTypeCreator<Holder> mCreator;

    private final TypeDecider<D> mDecider;

    private final ViewEventPerformer<Holder> mViewEventPerformer;

    public ViewTypeBinder(TypeDecider<D> decider,ViewTypeCreator<Holder> creator,ViewEventPerformer<Holder> performer,ViewInjector<D,Holder> injector){
       this(decider,creator,performer,injector,null);
    }
    public ViewTypeBinder(TypeDecider<D> decider,ViewTypeCreator<Holder> creator,ViewEventPerformer<Holder> performer){
        this(decider,creator,performer,null,null);
    }
    public ViewTypeBinder(TypeDecider<D> decider,ViewTypeCreator<Holder> creator){
        this(decider,creator,null,null,null);
    }
    public ViewTypeBinder(TypeDecider<D> decider,ViewTypeCreator<Holder> creator,ViewInjector<D,Holder> injector){
        this(decider,creator,null,injector,null);
    }
    public ViewTypeBinder(ViewTypeCreator<Holder> creator,ViewInjector<D,Holder> injector){
        this(null,creator,null,injector,null);
    }
    public ViewTypeBinder(ViewTypeCreator<Holder> creator,ViewEventPerformer<Holder> performer){
        this(null,creator,performer,null,null);
    }
    public ViewTypeBinder(ViewTypeCreator<Holder> creator,ViewEventPerformer<Holder> performer,ViewInjector<D,Holder> injector){
        this(null,creator,performer,injector,null);
    }
    public ViewTypeBinder(ViewTypeCreator<Holder> creator){
        this(null,creator,null,null,null);
    }
    public ViewTypeBinder(TypeDecider<D> decider,ViewTypeCreator<Holder> creator,ViewEventPerformer<Holder> performer,ViewInjector<D,Holder> injector,ViewHolderMonitor<D,Holder> monitor){
        mDecider = decider;
        mCreator = creator;
        mViewEventPerformer = performer;
        mInjector = injector;
        mMonitor = monitor;
        if(mCreator==null){
            throw new IllegalArgumentException("ViewTypeCreator can not be null");
        }
    }

    @Nullable
    @Override
    public final Holder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        Holder holder= mCreator.onCreateViewHolder(adapter, parent);
        if(mViewEventPerformer!=null){
           mViewEventPerformer.onPerformEvent(adapter,holder);
        }
        return holder;
    }

    @Override
    public final void onAttachToWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mMonitor != null) {
            mMonitor.onAttachToWindow(adapter, holder);
        }
    }

    @Override
    public final void onDetachFromWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mMonitor != null) {
            mMonitor.onDetachFromWindow(adapter, holder);
        }
    }

    @Override
    public final void onBindViewHolder(RecyclerAdapter<D> adapter, int position, @NonNull Holder holder, List<Object> payloads) {
        if (mInjector != null) {
            mInjector.onBindViewHolder(adapter, position, holder, payloads);
        }
    }

    @Override
    public final void onUnbindViewHolder(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mInjector != null) {
            mInjector.onUnbindViewHolder(adapter, holder);
        }
    }

    @Override
    public final boolean typeOf(RecyclerAdapter<D> adapter, int position) {
        if (mDecider != null) {
            return mDecider.typeOf(adapter, position);
        }
        return true;
    }
}
