package android.dev.support.recycler.adapter;

import android.dev.support.recycler.adapter.caller.SuccinctPool;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;

import java.util.List;

/**
 * Created by wbs on 2017/8/30 0030.
 * Note: the callback calls onCreateViewHolder->onBindViewHolder
 * ->onAttachToWindow->onDetachedFromWindow->onViewRecycled
 */

public class SuccinctViewAdapter<D,Holder extends ViewTypeHolder> extends RecyclerViewAdapter<D,Holder> {

    private final SuccinctPool<D,Holder> mPool;

    public SuccinctViewAdapter(SuccinctPool<D,Holder> pool) {
        mPool = pool;
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
    }

    protected Holder createItemViewHolder(ViewGroup parent, int viewType) {
        return mPool.onCreateViewHolder(this, parent, viewType);
    }

    @Override
    public void onBindViewHolder(Holder holder, int position, List<Object> payloads) {
        mPool.onBindViewHolder(this, holder, position, payloads);
    }

    @Override
    public void onViewAttachedToWindow(Holder holder) {
        mPool.onAttachToWindow(this, holder);
}

    @Override
    public void onViewDetachedFromWindow(Holder holder) {
        mPool.onDetachFromWindow(this, holder);
    }

    @Override
    public void onViewRecycled(Holder holder) {
        mPool.onUnbindViewHolder(this, holder);
    }

    @Override
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
    }

    public SuccinctPool<D,Holder> getPool(){
        return mPool;
    }

    @Override
    public final int getItemViewType(int position) {
        return mPool.getItemViewType(this, position);
    }


}
