package android.dev.support.recycler.adapter;

import android.support.v7.widget.RecyclerView;

import java.util.List;

/**
 * Created by wbs on 2017/12/18 0018.
 */

public interface RecyclerAdapter<D> {

    //common adapter start
    void add(D item);

    void add(int position,D item);

    void addData(List<? extends D> data);

    void remove(D item);

    void remove(int position);

    void refreshData(List<? extends D> data);

    void clear();

    D getItem(int position);

    long getItemId(int position);

    List<D> getCollections();

    int getItemCount();

    void notifyDataSetChanged();
    //common adapter end

    void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer);

    void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer);

    int getItemViewType(int position);

    boolean hasStableIds();

    void notifyItemChanged(int position);

    void notifyItemChanged(int position, Object payload);

    void notifyItemRangeChanged(int positionStart, int itemCount);

    void notifyItemRangeChanged(int positionStart, int itemCount, Object payload);

    void notifyItemInserted(int position);

    void notifyItemMoved(int fromPosition, int toPosition);

    void notifyItemRangeInserted(int positionStart, int itemCount);

    void notifyItemRemoved(int position);

    void notifyItemRangeRemoved(int positionStart, int itemCount);

}
