package android.dev.support.recycler.adapter.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.RecyclerViewAdapter;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.ViewGroup;

import java.util.List;

/**
 * Created by wbs on 2017/8/30 0030.
 */

public class ViewTypeBinder<D,Holder extends ViewTypeHolder> implements ViewHolderMonitor<D,Holder>,
        ViewTypeCreator<Holder>, ViewTypeInjector<D,Holder> {

    private final ViewHolderMonitor<D,Holder> mMonitor;

    private final ViewTypeInjector<D,Holder> mInjector;

    private final ViewTypeCreator<Holder> mCreator;

    @LayoutRes
    private final int mLayout;

    public ViewTypeBinder(ViewTypeInjector<D,Holder> injector,@NonNull ViewTypeCreator<Holder> creator) {
        this(injector, 0, null, creator);
    }

    public ViewTypeBinder(ViewTypeInjector<D,Holder> injector, ViewHolderMonitor<D,Holder> monitor,@NonNull ViewTypeCreator<Holder> creator) {
        this(injector, 0, monitor, creator);
    }

    protected ViewTypeBinder(ViewTypeInjector<D,Holder> injector, @LayoutRes int viewLayout, ViewHolderMonitor<D,Holder> monitor, ViewTypeCreator<Holder> creator) {
        this.mMonitor = monitor;
        this.mInjector = injector;
        this.mCreator = creator;
        mLayout = viewLayout;
        if (mLayout == 0 && mCreator == null) {
            throw new IllegalArgumentException("ViewTypeCreator or viewLayout you must init once");
        }
    }

    @LayoutRes
    public final int getItemViewLayout() {
        return mLayout;
    }

    @Nullable
    @Override
    public Holder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent) {
        if (mCreator != null) {
            return mCreator.onCreateViewHolder(adapter, parent);
        }
        return null;
    }

    @Override
    public final void onAttachToWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mMonitor != null) {
            mMonitor.onAttachToWindow(adapter, holder);
        }
    }

    @Override
    public final void onDetachFromWindow(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mMonitor != null) {
            mMonitor.onDetachFromWindow(adapter, holder);
        }
    }

    @Override
    public final void onBindViewHolder(RecyclerAdapter<D> adapter, int position, @NonNull Holder holder, List<Object> payloads) {
        if (mInjector != null) {
            mInjector.onBindViewHolder(adapter, position, holder, payloads);
        }
    }

    @Override
    public final void onUnbindViewHolder(RecyclerAdapter<D> adapter, @NonNull Holder holder) {
        if (mInjector != null) {
            mInjector.onUnbindViewHolder(adapter, holder);
        }
    }

    @Override
    public final boolean typeOf(RecyclerAdapter<D> adapter, int position) {
        if (mInjector != null) {
            return mInjector.typeOf(adapter, position);
        }
        return true;
    }
}
