package android.dev.support.recycler.adapter;

import android.dev.support.recycler.adapter.caller.SuccinctPool;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.dev.support.recycler.gesture.DefaultItemTouchHelperCallback;
import android.dev.support.recycler.gesture.ItemEffectProvider;
import android.dev.support.recycler.gesture.ItemMovementProvider;
import android.dev.support.recycler.gesture.ItemTouchResultCallback;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.helper.ItemTouchHelper;

import java.util.Collections;

/**
 * Created by wbs on 2017/12/8 0008.
 */

public class RecyclerViewDragAdapter<D,Holder extends ViewTypeHolder> extends SuccinctViewAdapter<D,Holder>
        implements ItemTouchResultCallback {

    private final ItemTouchHelper mItemTouchHelper;

    private final DefaultItemTouchHelperCallback mCallback;


    public RecyclerViewDragAdapter(SuccinctPool<D, Holder> pool) {
        super(pool);
        mCallback = new DefaultItemTouchHelperCallback(this);
        mItemTouchHelper = new ItemTouchHelper(mCallback);
    }

    public void setLongPressDragEnable(boolean enable) {
        mCallback.setLongPressDragEnabled(enable);
    }

    public void setItemMovementProvider(ItemMovementProvider provider) {
        mCallback.setItemMovementProvider(provider);
    }

    public void setItemEffectProvider(ItemEffectProvider provider) {
        mCallback.setItemEffectProvider(provider);
    }

    public void setSwipeEnable(boolean b) {
        mCallback.setSwipeEnable(b);
    }

    @Override
    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        mItemTouchHelper.attachToRecyclerView(recyclerView);
    }

    @Override
    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        mItemTouchHelper.attachToRecyclerView(null);
    }

    @Override
    public boolean onItemMove(int fromPosition, int toPosition) {
        if (fromPosition < toPosition) {
            for (int i = fromPosition; i < toPosition; i++) {
                Collections.swap(mData, i, i + 1);
            }
        } else {
            for (int i = fromPosition; i > toPosition; i--) {
                Collections.swap(mData, i, i - 1);
            }
        }
        notifyItemMoved(fromPosition, toPosition);
        return true;
    }

    @Override
    public void onItemDismiss(int position) {
        remove(position);
    }

    public ItemTouchHelper getItemTouchHelper(){
        return mItemTouchHelper;
    }
}
