package android.dev.support.recycler.adapter;

import android.dev.base.support.Adapter;
import android.support.v7.widget.RecyclerView;

/**
 * Created by wbs on 2017/12/18 0018.
 */

public interface RecyclerAdapter<D> extends Adapter<D> {

    void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer);

    void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer);

    int getItemViewType(int position);

    boolean hasStableIds();

    void notifyItemChanged(int position);

    void notifyItemChanged(int position, Object payload);

    void notifyItemRangeChanged(int positionStart, int itemCount);

    void notifyItemRangeChanged(int positionStart, int itemCount, Object payload);

    void notifyItemInserted(int position);

    void notifyItemMoved(int fromPosition, int toPosition);

    void notifyItemRangeInserted(int positionStart, int itemCount);

    void notifyItemRemoved(int position);

    void notifyItemRangeRemoved(int positionStart, int itemCount);

}
