package android.dev.support.recycler.ui;

import android.app.Activity;
import android.dev.base.support.BaseFragment;
import android.dev.support.recycler.R;
import android.dev.support.recycler.adapter.RecyclerViewAdapter;
import android.dev.support.recycler.adapter.SuccinctViewAdapter;
import android.dev.support.recycler.adapter.caller.RecyclerItemClickListener;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/7 0007.
 */

public abstract class BaseRecyclerFragment<RContext extends Activity,D,Holder extends ViewTypeHolder,
        Adapter extends RecyclerViewAdapter<D,Holder>> extends BaseFragment<RContext> implements RecyclerItemClickListener {

    private RecyclerView mRecyclerView;

    private Adapter mAdapter;

    @Override
    protected View onCreateContentView(LayoutInflater inflater, ViewGroup container, Bundle bundle) {
        RecyclerView recyclerView = new RecyclerView(getContext());
        recyclerView.setId(R.id.recyclerView);
        recyclerView.setOverScrollMode(View.OVER_SCROLL_NEVER);
        recyclerView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
        return recyclerView;
    }

    @Override
    protected final void initComponents(View createView, Bundle savedInstanceState) {
        mRecyclerView = createView.findViewById(R.id.recyclerView);
        if(mRecyclerView==null){
            throw new IllegalArgumentException("not find recyclerView by id [R.id.recyclerVIew] real val:"+R.id.recyclerView);
        }
        mRecyclerView.setLayoutManager(generateLayoutManager());
        RecyclerView.ItemDecoration decoration = generateItemDecoration();
        if(decoration!=null){
            mRecyclerView.addItemDecoration(decoration);
        }
        initExtraComponents(createView,savedInstanceState);
    }

    protected RecyclerView.LayoutManager generateLayoutManager(){
        LinearLayoutManager manager = new LinearLayoutManager(getContext());
        manager.setOrientation(LinearLayoutManager.VERTICAL);
        return manager;
    }

    protected void setAdapter(Adapter adapter){
        setAdapter(adapter,false);
    }

    protected void setAdapter(Adapter adapter,boolean registerClickEvent){
        if(adapter==null){
            mRecyclerView.setAdapter(null);
            return;
        }
        Adapter mOldAdapter = mAdapter;
        if(mOldAdapter!=null&&mOldAdapter!=adapter){
            if(mOldAdapter instanceof SuccinctViewAdapter){
                SuccinctViewAdapter adapt = (SuccinctViewAdapter) mOldAdapter;
                adapt.getPool().reset();
            }
        }
        this.mAdapter = adapter;
        mRecyclerView.setAdapter(mAdapter);
        if(registerClickEvent){
            mAdapter.setItemClickListener(this);
        }
    }

    @Override
    public void onItemClicked(RecyclerView.Adapter adapter, RecyclerView.ViewHolder holder, int position) {

    }

    protected RecyclerView getRecyclerView(){
        return mRecyclerView;
    }

    protected Adapter getAdapter(){
        return mAdapter;
    }

    protected RecyclerView.ItemDecoration generateItemDecoration(){
        return null;
    }

    protected abstract void initExtraComponents(View view,Bundle savedInstanceState);


    @Override
    public void onDestroy() {
        setAdapter(null);
        super.onDestroy();
    }
}
