package android.dev.support.recycler.adapter.binder;

import android.dev.support.recycler.adapter.RecyclerAdapter;
import android.dev.support.recycler.adapter.caller.ViewTypeInjector;
import android.dev.support.recycler.adapter.creator.ViewTypeCreator;
import android.dev.support.recycler.adapter.holder.ViewHolderMonitor;
import android.dev.support.recycler.adapter.holder.ViewTypeHolder;
import android.support.annotation.NonNull;
import android.view.ViewGroup;

/**
 * Created by wbs on 2017/12/7 0007.
 */

public final class UnknownViewTypeBinder<D,Holder extends ViewTypeHolder> extends ViewTypeBinder<D,Holder> {

    public final static int UN_KNOWN_VIEW_TYPE = -1;

    private final ViewTypeCreator<Holder> mCreator;

    public UnknownViewTypeBinder(@NonNull ViewTypeCreator<Holder> creator){
        super(null,creator);
        mCreator = creator;
    }

    public UnknownViewTypeBinder(ViewTypeInjector<D,Holder> injector, ViewTypeCreator<Holder> mCreator) {
        super(injector, mCreator);
        this.mCreator = mCreator;
    }

    public UnknownViewTypeBinder(ViewTypeInjector<D,Holder> injector, ViewHolderMonitor<D,Holder> monitor,
                                 ViewTypeCreator<Holder> mCreator) {
        super(injector, monitor, mCreator);
        this.mCreator = mCreator;
    }

    @NonNull
    @Override
    public final Holder onCreateViewHolder(RecyclerAdapter<?> adapter, ViewGroup parent){
        return mCreator.onCreateViewHolder(adapter,parent);
    }
}
