package android.dev.decoupling

import org.gradle.api.Project

class TargetDependency implements Dependency {

    private final Object target

    private TargetDependency(Object target) {
        this.target = target
    }

    public static TargetDependency create(Object target){
        return new TargetDependency(target)
    }

    @Override
    int getType() {
        return TYPE_TARGET
    }

    @Override
    Object getDepend(Project project) {
        return target
    }

    @Override
    String toString() {
        return target.toString()
    }
}