package android.dev.decoupling

class ProjectTaskHolder {

    private final String name

    private final Set<String> tasks = new HashSet<>()

    ProjectTaskHolder(String name) {
        this.name = name
    }

    public void addTaskName(String name) {
        tasks.add(name)
    }

    public boolean isAssembleTask() {
        return !tasks.isEmpty()
    }

    @Override
    String toString() {
        StringBuilder builder = new StringBuilder()
        builder.append("ProjectTaskHolder[$name]:{\n")
        for (String task : tasks) {
            builder.append(tasks).append("\n")
        }
        builder.append("}\n")
        return builder.toString()
    }

    boolean isBatchTask() {
        return tasks.size() > 1
    }
    Set<String> getTasks(){
        return tasks
    }
}