package android.dev.decoupling

import org.gradle.api.NamedDomainObjectContainer
import org.gradle.api.Project

/**
 * :Active:generateDebugSources
 :Active:generateDebugAndroidTestSources
 :Active:mockableAndroidJar
 :DownloadEngine:generateDebugSources
 :DownloadEngine:generateDebugAndroidTestSources
 :DownloadEngine:mockableAndroidJar
 :AppBusiness:generateDebugSources
 :AppBusiness:generateDebugAndroidTestSources
 :AppBusiness:mockableAndroidJar
 :Foundation:generateDebugSources
 :Foundation:generateDebugAndroidTestSources
 :Foundation:mockableAndroidJar
 */
@Deprecated
class PluginV1Worker extends PluginWork {


    @Override
    void apply(Project project) {
        if (!project.rootProject.hasProperty(PROPERTY_MAIN_MODULAR)) {
            throw new RuntimeException("you must set mainModular in root project gradle.properties")
        }
        String currentModule = project.name
        String mainModule = project.rootProject.property(PROPERTY_MAIN_MODULAR)
        String independentModule
        if (project.rootProject.hasProperty(PROPERTY_INDEPENDENT_MODULAR)) {
            independentModule = project.rootProject.property(PROPERTY_INDEPENDENT_MODULAR)
        } else {
            independentModule = mainModule
        }

        List<String> taskNames = project.gradle.startParameter.taskNames

        final String task = findAssembleTaskRealName(taskNames)

        final boolean isAssembleTask = task != null
        final boolean isAppApply = currentModule == mainModule || currentModule == independentModule

        log("apply module $currentModule with [$mainModule,$independentModule] " + (isAssembleTask ? "be assembled" : "be build"))

        if (isAssembleTask && !isAppApply) {
            applyProjectLibrary(project)
        } else {
            applyProjectApplication(project, currentModule == mainModule)
        }

        NamedDomainObjectContainer<BuildTypes> buildTypes = project.container(BuildTypes.class)
        NamedDomainObjectContainer<Flavors> flavors = project.container(Flavors.class)
        DependencyExtension extension = new DependencyExtension(flavors, buildTypes)
        project.extensions.add(EXTENSION_NAME, extension)
        project.afterEvaluate {
            DependencyExtension de = project.extensions.getByName(EXTENSION_NAME)

            if (de == null) {
                return
            }
//            isDeBug = de.isDebug
            if (isDeBug) {
                dumpUserConfiguration(de)
            }
            if (!isAssembleTask) {
                return
            }

            Closure sharedClosure = de.mSharedClosure
            if (sharedClosure != null) {
                sharedClosure.call()
            }

            Flavors flavor = getFlavor(task, de)
            BuildTypes buildType = getBuildType(task, de)
            String typeName = buildType == null ? "None" : buildType.name
            String flavorName = flavor == null ? "None" : flavor.name
            log("matched buildType[$typeName],flavor[$flavorName]")
            if (flavor != null) {
                dependCompile(project, flavor.mBeans)
            }
            if (buildType != null) {
                dependCompile(project, buildType.mBeans)
            }

            log("apply plugin android.module.depends end")
        }
    }


    private static String findAssembleTaskRealName(List<String> names) {
        for (String task : names) {
            String lowercaseName = task.toLowerCase()
            if (lowercaseName.contains("assemble") || task.contains("aR")
                    || lowercaseName.contains("resguard")) {
                return task
            }
        }
        return null
    }

}