package android.dev.decoupling

import org.gradle.api.DefaultTask
import org.gradle.api.tasks.TaskAction

class Independent extends DefaultTask{



    @TaskAction
    def makeIndependent(){
        String moduleName = project.name
        println("start make module $moduleName independent")
        File file = new File('src/main/independent')
        if(!file.exists()){
            file.mkdirs()
        }
        if(!file.isDirectory()){
            file.delete()
            file.mkdirs()
        }
        File javaFile = checkAndCreateDir(file,'java')
        File comFile = checkAndCreateDir(javaFile,'com')
        File moduleFile = checkAndCreateDir(comFile,'module')
        File independent = checkAndCreateDir(moduleFile,'independent')

        File resFile = checkAndCreateDir(file,'res')
        checkAndCreateDir(resFile,'layout')
        checkAndCreateDir(resFile,'mipmap-mdpi')
        checkAndCreateDir(resFile,'mipmap-hdpi')
        checkAndCreateDir(resFile,'mipmap-xhdpi')
        checkAndCreateDir(resFile,'mipmap-xxhdpi')
        checkAndCreateDir(resFile,'mipmap-xxxhdpi')
        checkAndCreateDir(resFile,'values')
    }

    static File checkAndCreateDir(File parent,String dir){
        File file = new File(parent,dir)
        if(!file.exists()){
            file.mkdirs()
        }
        return file
    }
}