package android.dev.decoupling

import org.gradle.api.Project

final class FilesDependency implements Dependency {

    private final String path

    private FilesDependency(String path) {
        this.path = path
    }

    public static FilesDependency create(String path) {
        return new FilesDependency(path)
    }

    @Override
    String toString() {
        return "files($path)"
    }

    @Override
    final int getType() {
        return TYPE_FILES
    }

    @Override
    Object getDepend(Project project) {
        return project.files(path)
    }
}