package android.dev.decoupling

import org.gradle.api.Project

final class ProjectDependency implements Dependency {

    private final String path

    private ProjectDependency(String path) {
        this.path = path
    }

    public static ProjectDependency create(String path) {
        return new ProjectDependency(path)
    }

    @Override
    final int getType() {
        return TYPE_PROJECT
    }

    @Override
    Object getDepend(Project project) {
        return project.project(":$path")
    }

    @Override
    String toString() {
        return "project($path)"
    }
}