package android.dev.decoupling

import org.gradle.api.Project

class LibraryDependency implements Dependency {

    private final String notation

    private LibraryDependency(String notation) {
        this.notation = notation
    }

    public static LibraryDependency create(String notation) {
        return new LibraryDependency(notation)
    }

    public static LibraryDependency create(String group, String artfact, String version) {
        return new LibraryDependency("$group:$artfact:$version")
    }

    @Override
    String toString() {
        return notation
    }

    @Override
    final int getType() {
        return TYPE_LIBRARY
    }

    @Override
    Object getDepend(Project project) {
        return notation
    }
}