package android.dev.decoupling

import org.gradle.api.Project

final class FileTreeDependency implements Dependency {

    private final String include

    private final String dir

    private FileTreeDependency(String include, String dir) {
        this.include = include
        this.dir = dir
    }

    public static FileTreeDependency create(String include, String dir) {
        return new FileTreeDependency(include, dir)
    }

    @Override
    String toString() {
        return "fileTree(include:$include,dir:$dir)"
    }

    @Override
    final int getType() {
        return TYPE_FILE_TREE
    }

    @Override
    Object getDepend(Project project) {
        Map<String, ?> map = new HashMap<>()
        if (include != null) {
            map.put("include", include)
        }
        map.put("dir", dir)
        return project.fileTree(map)
    }
}