package android.dev.decoupling

import org.gradle.api.NamedDomainObjectContainer

class DependencyExtension {

    final NamedDomainObjectContainer<Flavors> flavors

    final NamedDomainObjectContainer<BuildTypes> buildTypes

    Closure mSharedClosure

    boolean isDebug = true

    DependencyExtension(NamedDomainObjectContainer<Flavors> flavors, NamedDomainObjectContainer<BuildTypes> buildTypes) {
        this.flavors = flavors
        this.buildTypes = buildTypes
    }

    void flavors(Closure closure) {
        flavors.configure(closure)
    }

    void buildTypes(Closure closure) {
        buildTypes.configure(closure)
    }

    void shares(Closure closure) {
        this.mSharedClosure = closure
    }

    void debug(boolean isDebug) {
        this.isDebug = isDebug
    }


}