package android.dev.decoupling

import java.util.regex.Pattern

@Deprecated
public class Dependable extends CompileBean {

    private final
    static Pattern LIBRARY = Pattern.compile('^[a-zA-Z]*:[^\\f\\r\\t\\n\'\":]+:[^\\f\\r\\t\\n\'\":]+:[^\\f\\r\\t\\n\'\":]+$')

    private final
    static Pattern PROJECT = Pattern.compile('^[a-zA-Z]*:project\\([a-zA-Z]+\\)$')

    private final static Pattern FILES = Pattern.compile('^[a-zA-Z]*:files\\(.*\\)$')

    private final
    static Pattern FILE_TREE = Pattern.compile('^[a-zA-Z]*:fileTree\\(include:[\\s*].*,dir:[\\s*].*\\)$')

    private final List<String> commands = new ArrayList<>()


    public void setCommands(ArrayList<?> imples) {
        commands.clear()
        commands.addAll(imples)
    }

    public List<CompileCmd> convert() {
        List<CompileCmd> depends = new ArrayList<>()
        commands.each {
            if (LIBRARY.matcher(it).matches()) {
                String[] splits = it.split(":")
                if (splits == null || splits.length != 4) {
                    throw new RuntimeException("$it is not a right pattern of library")
                }
                depends.add(CompileCmd.attach(splits[0], LibraryDependency.create(splits[1], splits[2], splits[3])))
            } else if (PROJECT.matcher(it).matches()) {
                int index = it.indexOf(":")
                String configuration = it.substring(0, index)
                int leftIndex = it.indexOf("(")
                int rightIndex = it.indexOf(")")
                if (index < 0 || leftIndex < 0 || rightIndex < 0 || leftIndex >= rightIndex) {
                    throw new RuntimeException("$it is not matched project")
                }
                String path = it.substring(leftIndex + 1, rightIndex)
                depends.add(CompileCmd.attach(configuration, ProjectDependency.create(path)))
            } else if (FILES.matcher(it).matches()) {//"compile:files(path)"
                int index = it.indexOf(":")
                String configuration = it.substring(0, index)
                int leftIndex = it.indexOf("(")
                int rightIndex = it.indexOf(")")
                if (index < 0 || leftIndex < 0 || rightIndex < 0 || leftIndex >= rightIndex) {
                    throw new RuntimeException("$it is not matched files")
                }
                String path = it.substring(leftIndex + 1, rightIndex)
                depends.add(CompileCmd.attach(configuration, FilesDependency.create(path)))
            } else if (FILE_TREE.matcher(it).matches()) {
                int index = it.indexOf(":")
                String configuration = it.substring(0, index)
                int leftIndex = it.indexOf("(")
                int rightIndex = it.indexOf(")")
                if (index < 0 || leftIndex < 0 || rightIndex < 0 || leftIndex >= rightIndex) {
                    throw new RuntimeException("$it is not matched fileTree")
                }
                String params = it.substring(leftIndex + 1, rightIndex)
                String[] values = params.split(",")
                String include = values[0].split(":")[1]
                String dir = values[1].split(":")[1]
                depends.add(CompileCmd.attach(configuration, FileTreeDependency.create(include, dir)))
            } else {
                throw new RuntimeException("$it don't match any pattern")
            }

        }
        depends.addAll(mBeans)
        return depends
    }


}