package android.dev.decoupling

class CompileBean {

    final ArrayList<CompileCmd> mBeans = new ArrayList<>()

    public void compile(String configuration,String group,String artifact,String version){
        addCmd(CompileCmd.attach(configuration,LibraryDependency.create(group,artifact,version)))
    }
    public void compile(String configuration,String notation){
        addCmd(CompileCmd.attach(configuration,LibraryDependency.create(notation)))
    }
    public void compile(String configuration,Object target){
        addCmd(CompileCmd.attach(configuration,TargetDependency.create(target)))
    }
    public void compileProject(String configuration,String path){
        addCmd(CompileCmd.attach(configuration,ProjectDependency.create(path)))
    }
    public void compileFiles(String configuration,String path){
        addCmd(CompileCmd.attach(configuration,FilesDependency.create(path)))
    }

    public void compileFileTree(String configuration,String dir){
        addCmd(CompileCmd.attach(configuration,FileTreeDependency.create(null,dir)))
    }

    public void compileFileTree(String configuration,String include,String dir){
        addCmd(CompileCmd.attach(configuration,FileTreeDependency.create(include,dir)))
    }
    //-----------api
    public void api(String group,String artifact,String version){
        compile("api",group,artifact,version)
    }
    public void api(String notation){
        compile("api",notation)
    }
    public void api(Object target){
      compile("api",target)
    }
    public void apiProject(String path){
        compileProject("api",path)
    }
    public void apiFiles(String path){
      compileFiles("api",path)
    }

    public void apiFileTree(String dir){
        compileFileTree("api",dir)
    }

    public void apiFileTree(String include,String dir){
        compileFileTree("api",include,dir)
    }

    //---implementation
    public void implementation(String group,String artifact,String version){
        compile("implementation",group,artifact,version)
    }
    public void implementation(String notation){
        compile("implementation",notation)
    }
    public void implementation(Object target){
        compile("implementation",target)
    }
    public void implementationProject(String path){
        compileProject("implementation",path)
    }
    public void implementationFiles(String path){
        compileFiles("implementation",path)
    }

    public void implementationFileTree(String dir){
        compileFileTree("implementation",dir)
    }

    public void implementationFileTree(String include,String dir){
        compileFileTree("implementation",include,dir)
    }
    //
    private void addCmd(CompileCmd cmd){
        mBeans.add(cmd)
    }


}