package android.dev.decoupling

import org.gradle.api.Named

public class BuildType implements Named {

    private final String name

    private final List<String> mImplementations = new ArrayList<>();

    private final List<String> mApis = new ArrayList<>();

    public BuildType(String name){
        this.name = name
    }

    public String getName(){
        return name
    }

    void setImplementations(ArrayList<?> imples){
        mImplementations.clear()
        mImplementations.addAll(imples)
    }

    void setApis(ArrayList<?> apis){
        mApis.clear()
        mApis.addAll(apis)
    }

    ArrayList<String> getImplementations(){
        return mImplementations
    }

    ArrayList<String> getApis(){
        return mApis;
    }

}