package android.dev.decoupling

import org.gradle.api.Named

public class Flavor implements Named {

    final String name

    private final List<String> mImplementations = new ArrayList<>();

    private final List<String> mApis = new ArrayList<>();

    public Flavor(String name){
        this.name = name
    }

    public String getName(){
        return name
    }

    void setImplementations(ArrayList<?> iterator){
        mImplementations.clear()
        mImplementations.addAll(iterator)
    }
    void setApis(ArrayList<?> apis){
        mApis.clear()
        mApis.addAll(apis)
    }

    ArrayList<String> getApis(){
        return mApis;
    }

    ArrayList<String> getImplementations(){
        return mImplementations
    }

}