package android.dev.decoupling

import org.gradle.api.NamedDomainObjectContainer
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.Task
import org.gradle.internal.reflect.Instantiator
import org.gradle.invocation.DefaultGradle

class DecouplingBuildPlugin implements Plugin<Project> {

    private final static String EXTENSION_NAME = "decouplingOption";

    private final static String PROPERTY_MAIN_MODULAR = "main_modular";

    private final static String PROPERTY_INDEPENDENT_MODULAR = "independent_modular";

    @Override
    void apply(Project project) {

        Instantiator instantiator = ((DefaultGradle) project.getGradle()).getServices().get(Instantiator)
        NamedDomainObjectContainer<Flavor> flavorsContainer = project.container(Flavor, new DecouplingFlavorFactory(instantiator))
        NamedDomainObjectContainer<BuildType> buildTypesContainer = project.container(BuildType, new DecouplingBuildTypeFactory(instantiator))
        CompileExtension extension = project.extensions.create(EXTENSION_NAME, CompileExtension.class, flavorsContainer, buildTypesContainer)
        log("start apply plugin DecouplingBuildPlugin-----------------------------")

        String startParameter = project.gradle.startParameter.toString()
        log("taskNames is  " + startParameter)

        String module = project.path.replace(":", "")
        log("current module is " + module)

        List<String> taskNames = project.gradle.startParameter.taskNames
        String task = findAssembleTaskRealName(taskNames)
        final boolean isAssembleTask = task!=null;
        if(!project.rootProject.hasProperty(PROPERTY_MAIN_MODULAR)){
            throw new RuntimeException("you must set mainModular in root project gradle.properties")
        }
        String mainModular = project.rootProject.property(PROPERTY_MAIN_MODULAR)
        log("mainModular = " + mainModular)
        String independentModular;
        if(project.rootProject.hasProperty(PROPERTY_INDEPENDENT_MODULAR)){
            independentModular = project.rootProject.property(PROPERTY_INDEPENDENT_MODULAR)
        }else {
            independentModular = mainModular
        }
        if(!isAssembleTask|| module == independentModular||module==mainModular){
            project.apply plugin: 'com.android.application'
            if(module!=mainModular){
                project.android.sourceSets {
                    main {
                        manifest.srcFile 'src/main/independent/AndroidManifest.xml'
                        java.srcDirs += ['src/main/independent/java']
                        res.srcDirs += ['src/main/independent/res']
                    }
                }
            }
        }else {
            project.apply plugin: 'com.android.library'
        }
        project.afterEvaluate {

            AssembleTask assembleTask = new AssembleTask()
            if (isAssembleTask) {
                NamedDomainObjectContainer<Flavor> flavors = extension.getFlavors()
                for (Flavor flavor : flavors) {
                    if (task.toLowerCase().contains(flavor.name.toLowerCase())) {
                        assembleTask.flavor = flavor;
                        break
                    }
                }
                if (assembleTask.flavor != null) {
                    log("match flavor :" + assembleTask.flavor.name)
                } else {
                    log("don't match flavor")
                }

                NamedDomainObjectContainer<BuildType> buildTypes = extension.getBuildTypes()

                for (BuildType buildType : buildTypes) {
                    if (task.toLowerCase().contains(buildType.name.toLowerCase())) {
                        assembleTask.buildType = buildType;
                        break
                    }
                }
                if (assembleTask.buildType != null) {
                    log("match buildType :" + assembleTask.buildType.name)
                } else {
                    log("don't match buildType")
                }

                if (assembleTask.flavor != null) {
                    Flavor flavor = assembleTask.flavor;
                    ArrayList<String> implementations = flavor.implementations;
                    if (implementations != null && implementations.size() > 0) {
                        for (String implementation : implementations) {
                            if (implementation.contains(":")) {//maven lib
                                project.dependencies.add("implementation", implementation)
                                log("add maven library :[" + implementation + "]")
                            } else {
                                project.dependencies.add("implementation", project.project(":" + implementation))
                                log("add project library :[" + implementation + "]")
                            }
                        }
                    }
                    ArrayList<String> apis = flavor.apis;
                    if (apis != null && apis.size() > 0) {
                        for (String api : apis) {
                            if (api.contains(":")) {//maven lib
                                project.dependencies.add("api", api)
                                log("add maven library :[" + api + "]")
                            } else {
                                project.dependencies.add("api", project.project(":" + api))
                                log("add project library :[" + api + "]")
                            }
                        }
                    }
                }
                if (assembleTask.buildType != null) {
                    BuildType buildType = assembleTask.buildType;
                    ArrayList<String> implementations = buildType.implementations;
                    if (implementations != null && implementations.size() > 0) {
                        for (String implementation : implementations) {
                            if (implementation.contains(":")) {//maven lib
                                project.dependencies.add("implementation", implementation)
                                log("add maven library :[" + implementation + "]")
                            } else {
                                project.dependencies.add("implementation", project.project(":" + implementation))
                                log("add project library :[" + implementation + "]")
                            }
                        }
                    }
                    ArrayList<String> apis = buildType.apis;
                    if (apis != null && apis.size() > 0) {
                        for (String api : apis) {
                            if (api.contains(":")) {//maven lib
                                project.dependencies.add("api", api)
                                log("add maven library :[" + api + "]")
                            } else {
                                project.dependencies.add("api", project.project(":" + api))
                                log("add project library :[" + api + "]")
                            }
                        }
                    }

                }
            }


            log("end apply plugin DecouplingBuildPlugin-------------------------------")
        }


    }

    private static void log(String msg) {
        System.out.println("Decoupling Build >>>>>>>>>>>>>>>>>>> ["+msg+"]")
    }

    private static String findAssembleTaskRealName(List<String> names) {
        for (String task : names) {
            String lowercaseName = task.toLowerCase()
            log("task name = " + lowercaseName)
            if (lowercaseName.contains("assemble") || task.contains("aR")
                    || lowercaseName.contains("resguard")) {
                return task
            }
        }
        return null
    }
}