
package android.dev.base.life.transformer;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;


public class BindLifecycleObservableTransformer<T> implements ObservableTransformer<T, T> {
    private final BehaviorProcessor<Lifecycle.Event> lifecycleBehavior;

    private BindLifecycleObservableTransformer() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public BindLifecycleObservableTransformer(@NonNull BehaviorProcessor<Lifecycle.Event> lifecycleBehavior) {
        this.lifecycleBehavior = lifecycleBehavior;
    }

    @Override
    public ObservableSource<T> apply(Observable<T> upstream) {
        return upstream.takeUntil(
                lifecycleBehavior.skipWhile(new Predicate<Lifecycle.Event>() {
                    @Override
                    public boolean test(Lifecycle.Event event) throws Exception {
                        return event != Lifecycle.Event.ON_DESTROY;
                    }
                }).toObservable()
        );
    }
}