
package android.dev.base.life.transformer;

import android.arch.lifecycle.Lifecycle;
import android.support.annotation.NonNull;

import org.reactivestreams.Publisher;

import io.reactivex.Flowable;
import io.reactivex.FlowableTransformer;
import io.reactivex.functions.Predicate;
import io.reactivex.processors.BehaviorProcessor;


public class BindLifecycleFlowableTransformer<T> implements FlowableTransformer<T, T> {
    private final BehaviorProcessor<Lifecycle.Event> lifecycleBehavior;

    private BindLifecycleFlowableTransformer() throws IllegalAccessException {
        throw new IllegalAccessException();
    }

    public BindLifecycleFlowableTransformer(@NonNull BehaviorProcessor<Lifecycle.Event> lifecycleBehavior) {
        this.lifecycleBehavior = lifecycleBehavior;
    }

    @Override
    public Publisher<T> apply(final Flowable<T> upstream) {
        return upstream.takeUntil(
                lifecycleBehavior.skipWhile(new Predicate<Lifecycle.Event>() {
                    @Override
                    public boolean test(Lifecycle.Event event) throws Exception {
                        return event != Lifecycle.Event.ON_DESTROY;
                    }
                })
        );
    }
}