
package android.dev.base.life;

import android.arch.lifecycle.Lifecycle.Event;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;

import io.reactivex.processors.BehaviorProcessor;


public class LifecyclePublisher implements LifecycleObserver {

    private final BehaviorProcessor<Event> behavior = BehaviorProcessor.create();

    public BehaviorProcessor<Event> getBehavior() {
        return behavior;
    }

    @OnLifecycleEvent(Event.ON_CREATE)
    public void onCreate() {
        behavior.onNext(Event.ON_CREATE);
    }

    @OnLifecycleEvent(Event.ON_START)
    public void onStart() {
        behavior.onNext(Event.ON_START);
    }

    @OnLifecycleEvent(Event.ON_RESUME)
    public void onResume() {
        behavior.onNext(Event.ON_RESUME);
    }

    @OnLifecycleEvent(Event.ON_PAUSE)
    public void onPause() {
        behavior.onNext(Event.ON_PAUSE);
    }

    @OnLifecycleEvent(Event.ON_STOP)
    public void onStop() {
        behavior.onNext(Event.ON_STOP);
    }

    @OnLifecycleEvent(Event.ON_DESTROY)
    public void onDestroy() {
        behavior.onNext(Event.ON_DESTROY);
    }

}
